(defmeth vista-loglinear-proto :print-fit-information (window)
  (let* ((w window)
         (cur-model (send self :curr-model))
         (dev (send 
               cur-model
     	         :deviance))
         (chi (send 
               cur-model
               :chi))
         (fitted-zeros (send cur-model :fitted-zeros))
         (df (send cur-model :df))
         (p-chi (- 1 (if (= df 0) 0 (chisq-cdf chi df))))
         (p (- 1 (if (= df 0) 0 (chisq-cdf dev df)))))
    (print "helo")
    (add-text w 
              (format nil "Deviance=   ~,5f df=  ~d p= ~,5f ~%Chi-Square= ~,5f df=  ~d p= ~,5f ~%AIC ~,5g ~%BIC ~,5f  "
                      dev df p chi df p-chi (send cur-model :aic) (send cur-model :bic)))
    (when fitted-zeros 
          (add-text w (format nil "~%Warning: This model has fitted zeros. Check the report for additional information")))
    (send w :fit-window-to-text)))

(defmeth vista-loglinear-proto :nested-model? (list1 list2)    
"The lists are the models as obtained by sending the message :model to the vista-loglinear-proto. If there is a element that is not in the :list-terms slot it also results in non-nested"
      (let* (
             (longer-list (if (>= (length list1) (length list2)) list1 list2) :test 'equal)
             (shorter-list (if (< (length list1) (length list2)) list1 list2) :test 'equal))
        
            (and (null (set-difference shorter-list (send self :list-terms) :test 'equal))
                 (null (set-difference longer-list (send self :list-terms) :test 'equal))
                 (null (set-difference shorter-list longer-list :test 'equal)))

                   ))

(defmeth vista-loglinear-proto :predictor-names ()
          (let* (
                 (terms (expand-hierarchy 
                         (list (iseq (length (send self :vars))))))
                 (terms-selected (select (send self :terms) 
                                         (position (send self :curr-model) 
                                                   (send self :models-adjusted-list))))
                 (terms-selected-without-indicators 
                  (select terms-selected 
                          (which (mapcar #'(lambda (ter) (< ter (length terms)))
                                         terms-selected))))
                 
                 (indicators (send self :label-current-indicators))
                 (pn
                  (if (send self :level-labels) 
                      (remove 'nil (combine
                                    (send (send self :curr-model)
                                          :my-make-names 
                                          (select terms terms-selected-without-indicators)
                                          (send self :vars)
                                          (mapcar 'sort-data (send self :level-labels))
                                          (send self :excluded-categories))
                                    indicators))
                      (remove 'nil (combine
                                    (send (send self :curr-model)
                                          :my-make-names 
                                          (select terms terms-selected-without-indicators)
                                          (send v-log-lin-proto :vars)))
                              indicators))))
            pn))

(defmeth scatterplot-proto :my-new-plot (x y)
  (let*
    ((num-points (send self :num-points))
     (color (send self :point-color (iseq num-points)))
     (symbol (send self :point-symbol (iseq num-points)))
     (state (send self :point-state (iseq num-points)))
     (selection (send self :selection))
     (showing (send self :point-showing (iseq num-points)))
     (labels (send self :point-label (iseq num-points)))
     )
    (send self :start-buffering)
    (send self :clear-points)
    (send self :add-points x y)
    (send self :point-color (iseq num-points) color)
    (send self :point-symbol (iseq num-points) symbol)
    (send self :point-state (iseq num-points) state)
    (send self :selection selection)
    (send self :point-label (iseq num-points) labels)
    (send self :redraw)
    (send self :buffer-to-screen)
     ))

(defmeth vista-loglinear-proto :label-current-indicators ()

  (let* ((terms (expand-hierarchy 
                         (list (iseq (length (send self :vars))))))
         (terms-selected (select (send self :terms) 
                                         (position (send self :curr-model) 
                                                   (send self :models-adjusted-list))))
         (indicators-term (select terms-selected 
                          (which (mapcar #'(lambda (ter) (>= ter (length terms)))
                                         terms-selected)))))
  (mapcar #'(lambda (term) 
             (first (select (send self :indicators-list)
                      (- term (length (send self :list-terms))))))
          indicators-term)))

(defmeth vista-loglinear-proto :reference-category-dialog (&optional (spreadplot-object nil))
  (let* ((labels (send self :level-labels))
         (variable-names (mapcar #'(lambda (varname) (send text-item-proto :new varname ))
                                 (select (send self :variables)
                                         (which (mapcar #'(lambda (type) 
                                                            (or  (equal "CATEGORY" type) (equal "category" type) (equal "Category" type)))
                                                        (send self :slot-value 'vtypes))))))
         (choices 
          (mapcar #'(lambda (cats)
                      (send choice-item-proto 
                            :new cats 
                            ))
                      (send self :level-labels)))
         (Ok (send modal-button-proto :new "OK" 
                   :action #'(lambda ()
                               (send self :excluded-categories
                                     (mapcar #'(lambda (choice lab) 
                                                 (select lab (send choice :value)))
                                             choices labels))
                              (when spreadplot-object
                                    (send self :duplicate-model spreadplot-object))
                              (send dialog :close)
                               )))
         (apply (send modal-button-proto :new "Apply" 
                       :action #'(lambda () 
                                   (send self :excluded-categories
                                         (mapcar #'(lambda (choice lab) 
                                                     (select lab (send choice :value)))
                                                 choices labels))
                                   (when spreadplot-object
                                         (send self :duplicate-model spreadplot-object)) )))
        
         (dialog (send dialog-proto 
                       :new (list (mapcar #'(lambda (v c) (list v c)) variable-names choices)  (list Ok apply))
                       :title "Change reference categories"
                       ))
         )

    (defmeth dialog :modal-dialog-return (&optional args)
      )
      
    dialog))
        

(defmeth vista-loglinear-proto :duplicate-model (spreadplot-object &optional (indicator nil))
  "Indicators is a list of a string for the name of the indicator and a list for a dummy variable"
  (let* ((terms (expand-hierarchy 
                 (list (iseq (length (send self :vars))))))
         (terms-included (select (send self :terms)  
                                 (send self :current-num-adjusted-model)))
         (terms-in-model (select terms 
                                 (select terms-included
                                         (which (mapcar #'(lambda (ter)
                                                            (< ter (length terms)))	
                                                        terms-included )))))
         (indicators-in-model 
          (select terms-included 
                  (which (mapcar #'(lambda (sel) 
                                     (>= sel (length terms)))
                                 terms-included)))))

  (send self :terms (append (send self :terms) 
                                       (list (select (send self :terms) 
                                               (send self :current-num-adjusted-model)))))


  (send self :models-adjusted-list
                            (combine
                             (send self :models-adjusted-list)
                             (log-linear-model (send self :ncat)
                                               (send self :counts)
                                               terms-in-model
                                               (send self :vars)
                                               (mapcar 'sort-data (send self :level-labels))
                                               (send self :data-matrix)
                                               (send self :excluded-categories)
                                               (if indicators-in-model 
                                                  	(select (send self  :indicators-list) 
                                                     		(- indicators-in-model (length terms)))
								nil)
                                               )))

  (send self :model 
        (append (send self :model) 
                (list (select (send self :model) 
                        (send self :current-num-adjusted-model)))))
  (send self :curr-model 
        (car (reverse (send self :models-adjusted-list))))

    (send spreadplot-object :update-spreadplot "terms" "duplicate"
          (select (send self :terms) 
                  (send self :current-num-adjusted-model)))
    
    ))




(defmeth vista-loglinear-proto :rest-of-models (excluded-terms spreadplot-object)



  (let* (
         (terms (expand-hierarchy 
                (list (iseq (length (send self :vars))))))
         (included-terms (set-difference (iseq (length terms)) excluded-terms ))
                               
         )
    (mapcar #'(lambda (selection) 
                (setf terms-in-model (select terms (combine excluded-terms selection)))
                (send self :terms (append (send self :terms) 
                                          (list (combine excluded-terms selection))))

                (send self :models-adjusted-list
                      (combine
                       (send self :models-adjusted-list)
                       (log-linear-model (send self :ncat)
                                         (send self :counts)
                                         terms-in-model
                                         (send self :vars)
                                         (mapcar 'sort-data (send self :level-labels))
                                         (send self :data-matrix)
                                         (send self :excluded-categories)
                                         )))
                
                (send self :model 
                      (append (send self :model) 
                              (list (select (send self :list-terms) 
                                            (combine excluded-terms selection)))))
                (send self :curr-model 
                      (car (reverse (send self :models-adjusted-list))))
                
                (send spreadplot-object :update-spreadplot "terms" 0 
                      (select (send self :terms) 
                              (send self :current-num-adjusted-model))))
            (reverse (cdr (all-subsets included-terms))))))


                            
 (defmeth vista-loglinear-proto :current-num-adjusted-model ()
   
   (position (send self :curr-model) (send self :models-adjusted-list)))
  


;;Methods for building the dialog for individual terms not included in the model

(defmeth vista-loglinear-proto :out-of-model ()
  (let* (
         (terms (expand-hierarchy 
                 (list (iseq (length (send self :vars))))))
         (excluded-terms (select terms
                                 (set-difference (iseq (length terms))
                                                 (select (send self :terms)
                                                         (send self :current-num-adjusted-model)))))
         
         )
    excluded-terms))

(defmeth vista-loglinear-proto :make-names-term (term)
  (let* ((term (if (listp term) (first term) term))
         (vars-in-term (sort-data 
                        (select 
                         (expand-hierarchy 
                          (list (iseq (length (send self :vars)))))
                         term)))
         ; (cats-in-vars (select (send self :ncat) vars-in-term))
         (indicators-names (send (send self :curr-model)  :my-make-names  
                                 (list vars-in-term )
                                 (send self :vars) 
                                 (mapcar #'sort-data (send self  :level-labels)) 
                                 (send self :excluded-categories)
                                 t ;este ltimo parmetro garantiza que no aparezcan todos los trminos
                                 ))
         )
    
    
    indicators-names
    ))

  (defmeth vista-loglinear-proto :make-predictors-term (term)
    (let* ((term (if (listp term) (first term) term))
           (vars-in-term (sort-data 
                          (select 
                           (expand-hierarchy 
                          (list (iseq (length (send self :vars)))))
                         term)))
           (predictors (send (send self :curr-model)  :my-make-pred
                             (list vars-in-term )
                             (send self :data-matrix) 
                             (mapcar #'sort-data (send self  :level-labels)) 
                             (send self :excluded-categories)
                             t ;este ltimo parmetro garantiza que no aparezcan todos los trminos
                             ))
         )
      predictors
      ))


  (defmeth vista-loglinear-proto :build-indicators-dialog (term x y terms-window)
    (let* (
           (v-lg-object self)
           (window terms-window)
           (x x)
           (y y)
           (indicators-names (send self :make-names-term term))
           (vars-in-term (sort-data 
                          (combine (select 
                                    (expand-hierarchy 
                                     (list (iseq (length (send self :vars)))))
                                    term))))
           (cats-in-vars (select (send self :ncat) vars-in-term))
           (menu (send menu-proto :new "Indicators"))
           (choices 
            (mapcar #'(lambda (indic index)
                        (send menu-item-proto 
                              :new indic 
                              :action #'(lambda () 
                                               (send v-lg-object 
                                                :build-individual-predictor 
                                                indic 
                                                term 
                                                index
                                                (send window :spreadplot-object))
                                                     
                                          (send window :add-points 1 :point-labels 
                                                (list indic)))
                              ))
                              
                    indicators-names (iseq (length indicators-names))))
           )

           


           (mapcar #'(lambda (mitem)
                  (send menu :append-items mitem))
                   choices)
	  ; (send window :popup-menu-items choices)
      (mapcar #'(lambda (mitem indic) 
                       (send mitem   :enabled 
                             (null (member indic (mapcar #'first (send v-lg-object :indicators-list))
                                        :test 'equal))))
                   choices indicators-names)
    ;  (send window :menu menu)
           (send menu :install)
           (send menu :popup x y window)
	   (send menu :remove)
           ))
    
    (defmeth vista-loglinear-proto :build-individual-predictor 
  (name predictor index spreadplot-object)
      
      (send self :indicators-list (append (send self :indicators-list)
                                          (list (list name (select (send self :make-predictors-term predictor) index))))))